#include <amxmodx>
#include <sqlx>

#define PLUGIN "Multiserver Redirect"
#define VERSION "1.0"
#define AUTHOR "Sho0ter"

#define CONNECT_CHECK 0
#define MENU_CHECK 1

#define REDIRECT_FALSE 0
#define REDIRECT_IGNORE 1
#define REDIRECT_TRUE 2

#define UPDATE_TASK 21387

new Handle:tuple

new Trie:reserved_slots

new Array:retries_ids
new Array:retries_servers

new Array:server_name
new Array:server_ip
new Array:server_map
new Array:server_players
new Array:server_maxplayers
new Array:server_admins
new Array:server_password
new Array:server_online
new Array:server_noredirect
new Array:server_slots

new query_cache[1024]

new menu_position[33]
new sub_data[33]

new current_server

new pcvar_hpointer
new pcvar_hostname
new pcvar_pos
new pcvar_host
new pcvar_user
new pcvar_pass
new pcvar_db
new pcvar_slots
new pcvar_lan
new pcvar_retry
new pcvar_update
new pcvar_admins
new pcvar_password
new pcvar_noredirect
new pcvar_adm_slot
new pcvar_flag
new pcvar_calc

new maxplayers
new admins

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_dictionary("multiserver_redirect.txt")
	
	reserved_slots = TrieCreate()
	
	server_name = ArrayCreate(64)
	server_ip = ArrayCreate(32)
	server_map = ArrayCreate(32)
	server_password = ArrayCreate(32)
	server_players = ArrayCreate(1)
	server_maxplayers = ArrayCreate(1)
	server_admins = ArrayCreate(1)
	server_online = ArrayCreate(1)
	server_noredirect = ArrayCreate(1)
	server_slots = ArrayCreate(1)
	
	retries_ids = ArrayCreate(1)
	retries_servers = ArrayCreate(1)
	
	pcvar_hostname = register_cvar("msr_hostname", "")
	pcvar_pos = register_cvar("msr_position", "1")
	pcvar_host = register_cvar("msr_sql_host", "localhost")
	pcvar_user = register_cvar("msr_sql_user", "root")
	pcvar_pass = register_cvar("msr_sql_password", "password")
	pcvar_db = register_cvar("msr_sql_database", "multiserver_redirect")
	pcvar_slots = register_cvar("msr_reserved_slots", "0")
	pcvar_lan = register_cvar("msr_lan_reservation", "0")
	pcvar_retry = register_cvar("msr_retry", "0")
	pcvar_admins = register_cvar("msr_show_admins", "0")
	pcvar_update = register_cvar("msr_updaterate", "1.0")
	pcvar_password = register_cvar("msr_password", "password")
	pcvar_noredirect = register_cvar("msr_noredirect", "0")
	pcvar_adm_slot = register_cvar("msr_admin_slot", "1")
	pcvar_flag = register_cvar("msr_admin_flag", "b")
	pcvar_calc = register_cvar("msr_slots_calculate", "0")
	
	pcvar_hpointer = get_cvar_pointer("hostname")
	
	register_clcmd("say /server", "cmd_server")
	register_clcmd("say_team /server", "cmd_server")
	
	register_menucmd(register_menuid("redirect menu"), 1023, "main_menu")
	register_menucmd(register_menuid("redirect sub menu"), 1023, "sub_menu")
	
	maxplayers = get_maxplayers()
	
	return PLUGIN_CONTINUE
}

public plugin_cfg()
{
	new ini_file[128], temp[34], line, len
	
	get_localinfo("amxx_configsdir", ini_file, 127)
	
	server_cmd("exec %s/multiserver_redirect.cfg", ini_file)
	
	add(ini_file, 127, "/multiserver_redirect.ini")
	if(file_exists(ini_file))
	{
		while((line = read_file(ini_file, line, temp, 33, len)))
		{
			if(!len || temp[0] == ';')
			{
				continue
			}
			TrieSetCell(reserved_slots, temp, 1)
		}
	}
	
	set_task(1.0, "sql_init")
	
	return PLUGIN_CONTINUE
}

public sql_init()
{
	new host[64], user[64], pass[64], database[64]
	
	get_pcvar_string(pcvar_host, host, 63)
	get_pcvar_string(pcvar_user, user, 63)
	get_pcvar_string(pcvar_pass, pass, 63)
	get_pcvar_string(pcvar_db, database, 63)

	tuple = SQL_MakeDbTuple(host, user, pass, database)
	
	new error[1024], errornum
	
	new Handle:connect = SQL_Connect(tuple, errornum, error, 1023)
	
	if(connect == Empty_Handle)
	{
		return log_amx("Database connection failed [#%d]: %s", errornum, error)
	}

	SQL_FreeHandle(connect)
	
	new len
	
	len = format(query_cache, 1023, "CREATE TABLE IF NOT EXISTS `multiserver_redirect` (`server_id` int(8) NOT NULL, `server_name` varchar(64) NOT NULL, `server_ip` varchar(32) NOT NULL, `server_map` varchar(32) NOT NULL, `server_password` varchar(32) NULL, `server_players` int(8) NOT NULL, `server_maxplayers` int(8) NOT NULL, `server_admins` int(8) NOT NULL,")
	len += format(query_cache[len], 1023 - len, " `server_noredirect` int(8) NOT NULL, `server_slots` int(8) NOT NULL, `server_online` int(8) NOT NULL, `server_timestamp` int(8) NOT NULL, PRIMARY KEY (`server_id`)) ENGINE = MyISAM DEFAULT CHARSET = utf8;")
	
	return SQL_ThreadQuery(tuple, "sql_init_post", query_cache)
}

public sql_init_post(failstate, Handle:query, const error[], errornum, const qdata[], size, Float:queuetime)
{
	if(failstate)
	{
		return SQL_ThreadError(query, error, errornum, failstate)
	}
	
	SQL_FreeHandle(query)
	
	formatex(query_cache, 1023, "SELECT * FROM `multiserver_redirect` WHERE `server_id` = '%d';", get_pcvar_num(pcvar_pos))
	
	return SQL_ThreadQuery(tuple, "sql_init_next", query_cache)
}

public sql_init_next(failstate, Handle:query, const error[], errornum, const qdata[], size, Float:queuetime)
{
	if(failstate)
	{
		return SQL_ThreadError(query, error, errornum, failstate)
	}
	
	if(!SQL_NumResults(query))
	{
		new hostname[32]
		get_pcvar_string(pcvar_hostname, hostname, 63)
	
		if(!strlen(hostname))
		{
			get_pcvar_string(pcvar_hpointer, hostname, 63)
		}
		
		sql_safe(hostname, 63)
		
		formatex(query_cache, 1023, "INSERT INTO `multiserver_redirect` (`server_id`, `server_name`, `server_ip`, `server_map`, `server_password`, `server_players`, `server_maxplayers`, `server_admins`, `server_noredirect`, `server_slots`, `server_online`, `server_timestamp`) VALUES ('%d', '%s', '127.0.0.1', 'de_dust2', NULL, '0', '0', '0', '0', '0', '0', '0');", get_pcvar_num(pcvar_pos), hostname)
		
		SQL_FreeHandle(query)
		
		return SQL_ThreadQuery(tuple, "sql_init_final", query_cache)
	}
		
	return set_task(get_pcvar_float(pcvar_update), "update_data", UPDATE_TASK, _, _, "b")
}

public sql_init_final(failstate, Handle:query, const error[], errornum, const qdata[], size, Float:queuetime)
{
	if(failstate)
	{
		return SQL_ThreadError(query, error, errornum, failstate)
	}
	
	SQL_FreeHandle(query)
	
	return set_task(get_pcvar_float(pcvar_update), "update_data", UPDATE_TASK, _, _, "b")
}

public client_authorized(id)
{
	new redirect_server[32], redirect_password[32]
	switch(is_can_redirect(id, _, redirect_server, 31, redirect_password, 31, CONNECT_CHECK))
	{
		case REDIRECT_FALSE: server_cmd("kick #%d  %L", get_user_userid(id), id, "MSR_NO_FREE_SLOTS")
		case REDIRECT_IGNORE: return PLUGIN_CONTINUE
		case REDIRECT_TRUE: 
		{
			if(strlen(redirect_password))
			{
				return client_cmd(id, "setinfo ^"model^" ^"^"; setinfo ^"password^" ^"%s^"; Connect %s", redirect_password, redirect_server)
			}
			return client_cmd(id, "Connect %s", redirect_server)
		}
	}
	return PLUGIN_CONTINUE
}

public client_putinserver(id)
{
	if(is_user_admin(id))
	{
		admins++
	}
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	if(is_user_admin(id))
	{
		admins--
	}
	
	retry_check_and_delete(id)
	
	return PLUGIN_CONTINUE
}

public cmd_server(id)
{
	show_main_menu(id, menu_position[id] = 0)
	return PLUGIN_CONTINUE
}

public show_main_menu(id, position)
{
	if(position < 0)
	{
		return PLUGIN_HANDLED
	}
	
	new menu_body[1024]
	new menu_start = position * 7
	new menu_end = menu_start + 7
	new menu_key = 1
	new menu_keys = 0
	new menu_len
	
	if(menu_end > ArraySize(server_name))
	{
		menu_end = ArraySize(server_name)
	}
	
	menu_len = format(menu_body, 1023, "\y%s v%s by %s:^n^n", PLUGIN, VERSION, AUTHOR)
	
	new temp2[64], temp[32]
	
	for(new i = menu_start; i < menu_end; i++)
	{
		if(is_can_redirect(id, i, _, _, _, _, MENU_CHECK))
		{
			menu_keys |= (1 << (menu_key - 1))
			ArrayGetString(server_name, i, temp2, 64)
			
			menu_len += format(menu_body[menu_len], 1023 - menu_len, "\r%d. \w%s ", menu_key, temp2)
			ArrayGetString(server_map, i, temp, 31)
			
			menu_len += format(menu_body[menu_len], 1023 - menu_len, "\y[\w%s\y] (\w%d/%d\y)", temp, ArrayGetCell(server_players, i), ArrayGetCell(server_maxplayers, i))
			
			if(is_user_admin(id) && get_pcvar_num(pcvar_admins))
			{
				menu_len += format(menu_body[menu_len], 1023 - menu_len, " \y<= \w%d A", ArrayGetCell(server_admins, i))
			}
			
			menu_len += format(menu_body[menu_len], 1023 - menu_len, "^n")
		}
		else
		{
			ArrayGetString(server_name, i, temp2, 64)
			menu_len += format(menu_body[menu_len], 1023 - menu_len, "\r%d. \d%s ", menu_key, temp2)
			
			if(!ArrayGetCell(server_online, i))
			{
				menu_len += format(menu_body[menu_len], 1023 - menu_len, "(\r%L\d)^n", id, "MSR_DOWN")
			}
			else if(i == current_server)
			{
				menu_len += format(menu_body[menu_len], 1023 - menu_len, "(\y%L\d)^n", id, "MSR_CURRENT")
			}
			else
			{
				new disabled = ArrayGetCell(server_noredirect, i)
				if(get_pcvar_num(pcvar_retry) && disabled < 2) menu_keys |= (1 << (menu_key - 1))
				
				ArrayGetString(server_map, i, temp, 31)
				menu_len += format(menu_body[menu_len], 1023 - menu_len, "[\w%s\d] (%s%d/%d\d)", temp, (disabled < 2) ? "\r" : "\w", ArrayGetCell(server_players, i), ArrayGetCell(server_maxplayers, i))
				
				if(is_user_admin(id) && get_pcvar_num(pcvar_admins))
				{
					menu_len += format(menu_body[menu_len], 1023 - menu_len, " \d<= \w%d A", ArrayGetCell(server_admins, i))
				}
				
				menu_len += format(menu_body[menu_len], 1023 - menu_len, "^n")
			}
		}
		menu_key++
	}
	
	menu_keys |= (1 << 7)
	
	if(menu_end != ArraySize(server_name))
	{
		menu_keys |= (1 << 8)
	}
	
	menu_keys |= (1 << 9)
	menu_len += format(menu_body[menu_len], 1023 - menu_len, "^n\r8. \w%L^n^n\r9. %s%L^n\r0. \w%L", id, "MSR_REFRESH", (menu_end == ArraySize(server_name)) ? "\d" : "\w", id, "MSR_MORE", id, position ? "MSR_BACK" : "MSR_EXIT")

	return show_menu(id, menu_keys, menu_body, -1, "redirect menu")
}

public main_menu(id, key)
{
	switch(key)
	{
		case 7: show_main_menu(id, menu_position[id])
		case 8: show_main_menu(id, ++menu_position[id])
		case 9: show_main_menu(id, --menu_position[id])
		default:
		{
			new menu_choosed = (menu_position[id] * 7) + key
			
			new redirect_server[32], redirect_password[32]
			
			if(is_can_redirect(id, menu_choosed, redirect_server, 31, redirect_password, 31, MENU_CHECK))
			{
				if(strlen(redirect_password))
				{
					return client_cmd(id, "setinfo ^"model^" ^"^"; setinfo ^"password^" ^"%s^"; Connect %s", redirect_password, redirect_server)
				}
				else
				{
					return client_cmd(id, "Connect %s", redirect_server)
				}
			}
			else if(get_pcvar_num(pcvar_retry))
			{
				return show_sub_menu(id, menu_choosed)
			}
			else
			{
				client_print(id, print_chat, "[Multiserver Redirect] %L", id, "MSR_CHANGED")
			}
		}
	}
	
	return PLUGIN_HANDLED
}

public show_sub_menu(id, server_id)
{
	sub_data[id] = server_id
	
	new body[512], len, keys
	len = format(body[len], 511 - len, "\r%L\w^n", id, "MRS_SUB_HEADER")
	
	new is_retry = is_user_retry(id)

	keys |= (1<<0)|(1<<9)
	
	len += format(body[len], 511 - len, "%s%L^n^n\r1. \w%L", is_retry ? "\y" : "\d", id, is_retry ? "MSR_IN_RETRY" : "MSR_NO_RETRY", id, is_retry ? "MSR_OFF_RETRY" : "MSR_ON_RETRY")
	
	len += format(body[len], 511 - len, "^n^n\r0. \w%L", id, "MSR_BACK")
	
	return show_menu(id, keys, body, -1, "redirect sub menu")
}

public sub_menu(id, key)
{
	if(key == 9) return show_main_menu(id, menu_position[id])
	
	if(is_user_retry(id))
	{
		retry_check_and_delete(id)
	}
	else
	{
		retry_add(id, sub_data[id])
	}
	
	return show_sub_menu(id, sub_data[id])
}

public update_data()
{
	new hostname[64], map[32], ip[32], pass[32]

	get_pcvar_string(pcvar_hostname, hostname, 63)
	
	if(!strlen(hostname))
	{
		get_pcvar_string(pcvar_hpointer, hostname, 63)
	}

	sql_safe(hostname, 63)
	
	get_mapname(map, 31)
	get_user_ip(0, ip, 31)
	
	get_pcvar_string(pcvar_password, pass, 31)
	
	new len = format(query_cache, 1023, "SELECT * FROM `multiserver_redirect` ORDER BY `server_id` ASC; UPDATE `multiserver_redirect` SET `server_name` = '%s', `server_ip` = '%s', `server_map` = '%s', `server_password` = '%s', `server_players` = '%d', `server_maxplayers` = '%d', `server_admins` = '%d'", hostname, ip, map, pass, get_playersnum(1), maxplayers, admins)
	len += format(query_cache[len], 1023 - len, ", `server_noredirect` = '%d', `server_noredirect` = '%d', `server_online` = '1', `server_timestamp` = UNIX_TIMESTAMP(NOW()) WHERE `server_id` = '%d';", get_pcvar_num(pcvar_noredirect), get_pcvar_num(pcvar_slots), get_pcvar_num(pcvar_pos))
	len += format(query_cache[len], 1023 - len, "UPDATE `multiserver_redirect` SET `server_online` = '0' WHERE (`server_timestamp` + %d) <= UNIX_TIMESTAMP(NOW());", floatround(get_pcvar_float(pcvar_update)) * 4)
	
	return SQL_ThreadQuery(tuple, "update_data_post", query_cache)
}

public update_data_post(failstate, Handle:query, const error[], errornum, const qdata[], size, Float:queuetime)
{
	if(failstate)
	{
		return SQL_ThreadError(query, error, errornum, failstate)
	}
	
	if(!task_exists(UPDATE_TASK))
	{
		return SQL_FreeHandle(query)
	}
	
	ArrayClear(server_name)
	ArrayClear(server_ip)
	ArrayClear(server_map)
	ArrayClear(server_players)
	ArrayClear(server_maxplayers)
	ArrayClear(server_admins)
	ArrayClear(server_password)
	ArrayClear(server_online)
	ArrayClear(server_noredirect)
	ArrayClear(server_slots)

	new curpos
	
	new temp[64], itemp
	
	while(SQL_MoreResults(query))
	{
		itemp = SQL_ReadResult(query, 0)
		
		if(itemp == get_pcvar_num(pcvar_pos))
		{
			current_server = curpos
		}
		
		SQL_ReadResult(query, 1, temp, 63)		
		ArrayPushString(server_name, temp)
		SQL_ReadResult(query, 2, temp, 31)
		ArrayPushString(server_ip, temp)
		SQL_ReadResult(query, 3, temp, 31)
		ArrayPushString(server_map, temp)
		SQL_ReadResult(query, 4, temp)
		ArrayPushString(server_password, temp)
		ArrayPushCell(server_players, SQL_ReadResult(query, 5))
		ArrayPushCell(server_maxplayers, SQL_ReadResult(query, 6))
		ArrayPushCell(server_admins, SQL_ReadResult(query, 7))
		ArrayPushCell(server_noredirect, SQL_ReadResult(query, 8))
		ArrayPushCell(server_slots, SQL_ReadResult(query, 9))
		ArrayPushCell(server_online, SQL_ReadResult(query, 10))
		
		curpos ++
		
		SQL_NextRow(query)
	}
	
	SQL_FreeHandle(query)
	
	new arrsize = ArraySize(retries_ids)
	
	for(new i; i < arrsize; i++)
	{
		new id = ArrayGetCell(retries_ids, i)
		new redirect_server[32], redirect_password[32]
		if(is_can_redirect(id, ArrayGetCell(retries_servers, i), redirect_server, 31, redirect_password, 31, MENU_CHECK))
		{
			if(strlen(redirect_password))
			{
				client_cmd(id, "setinfo ^"model^" ^"^"; setinfo ^"password^" ^"%s^"; Connect %s", redirect_password, redirect_server)
			}
			else
			{
				client_cmd(id, "Connect %s", redirect_server)
			}
			
			ArraySetCell(server_players, ArrayGetCell(retries_servers, i), ArrayGetCell(server_players, ArrayGetCell(retries_servers, i)) + 1)
		}
	}
	
	return PLUGIN_CONTINUE
}

public plugin_end()
{
	if(tuple != Empty_Handle)
	{
		SQL_FreeHandle(tuple)
	}
	
	remove_task(UPDATE_TASK)
	
	TrieDestroy(reserved_slots)
	
	ArrayDestroy(server_name)
	ArrayDestroy(server_ip)
	ArrayDestroy(server_map)
	ArrayDestroy(server_players)
	ArrayDestroy(server_maxplayers)
	ArrayDestroy(server_admins)
	ArrayDestroy(server_password)
	ArrayDestroy(server_online)
	ArrayDestroy(server_noredirect)
	ArrayDestroy(server_slots)
	
	ArrayClear(retries_ids)
	ArrayClear(retries_servers)
	
	return PLUGIN_CONTINUE
}

stock is_can_redirect(id, server_id = 0, output[] = "", len = 0, output2[] = "", len2 = 0, type)
{
	switch(type)
	{
		case CONNECT_CHECK:
		{
			if(get_playersnum(1) < (maxplayers - get_pcvar_num(pcvar_slots)) || (is_have_slot(id) && get_playersnum(1) < maxplayers))
			{
				return REDIRECT_IGNORE
			}
			for(server_id = (current_server + 1); server_id < ArraySize(server_name); server_id++)
			{
				if(((ArrayGetCell(server_players, server_id) < (ArrayGetCell(server_maxplayers, server_id) - (ArrayGetCell(server_slots, server_id) + 2))) || is_have_slot(id) && get_pcvar_num(pcvar_calc) && (ArrayGetCell(server_players, server_id) < (ArrayGetCell(server_maxplayers, server_id) - 1))) && ArrayGetCell(server_online, server_id) && !ArrayGetCell(server_noredirect, server_id))
				{
					ArrayGetString(server_ip, server_id, output, len)
					ArrayGetString(server_password, server_id, output2, len2)
					return REDIRECT_TRUE
				}
			}
			for(server_id = 0; server_id < current_server; server_id++)
			{
				if(((ArrayGetCell(server_players, server_id) < (ArrayGetCell(server_maxplayers, server_id) - (ArrayGetCell(server_slots, server_id) + 2))) || is_have_slot(id) && get_pcvar_num(pcvar_calc) && (ArrayGetCell(server_players, server_id) < (ArrayGetCell(server_maxplayers, server_id) - 1))) && ArrayGetCell(server_online, server_id) && !ArrayGetCell(server_noredirect, server_id))
				{
					ArrayGetString(server_ip, server_id, output, len)
					ArrayGetString(server_password, server_id, output2, len2)
					return REDIRECT_TRUE
				}
			}
			return REDIRECT_FALSE
		}
		case MENU_CHECK:
		{
			if(((ArrayGetCell(server_players, server_id) < (ArrayGetCell(server_maxplayers, server_id) - (ArrayGetCell(server_slots, server_id) + 2))) || is_have_slot(id) && get_pcvar_num(pcvar_calc) && (ArrayGetCell(server_players, server_id) < (ArrayGetCell(server_maxplayers, server_id) - 1))) && ArrayGetCell(server_online, server_id) && server_id != current_server && ArrayGetCell(server_noredirect, server_id) < 2)
			{
				ArrayGetString(server_ip, server_id, output, len)
				ArrayGetString(server_password, server_id, output2, len2)
				return REDIRECT_TRUE
			}
			return REDIRECT_FALSE
		}
	}
	return REDIRECT_IGNORE
}

stock is_have_slot(id)
{
	new name[32], ip[32], steam[34]
	get_user_name(id, name, 31)
	get_user_ip(id, ip, 31, 1)
	get_user_authid(id, steam, 33)
	return ((get_user_flags(id) & get_slot_flag() && get_pcvar_num(pcvar_adm_slot)) || (!contain(ip, "10.") && get_pcvar_num(pcvar_lan)) || TrieKeyExists(reserved_slots, name) || TrieKeyExists(reserved_slots, ip) || TrieKeyExists(reserved_slots, steam))
}

stock SQL_ThreadError(Handle:query, const error[], errornum, failstate)
{
	log_amx("Threaded query error!")
	log_amx("Message #%d: %s", errornum, error)
	
	new pquery[1024]
	SQL_GetQueryString(query, pquery, 1023)
	
	log_amx("Query string: %s", pquery)
	
	if(failstate == TQUERY_CONNECT_FAILED)
	{
		log_amx("Fail state: Connection Failed")
	}
	else if(failstate == TQUERY_QUERY_FAILED)
	{
		log_amx("Fail state: Query Failed")
	}
	
	return SQL_FreeHandle(query)
}

stock is_user_admin(id)
{
	new flags = get_user_flags(id)
	return (flags > 0 && !(flags & ADMIN_USER))
}

stock get_slot_flag()
{
	new str[32]
	get_pcvar_string(pcvar_flag, str, 31)
	return read_flags(str)
}

stock retry_check_and_delete(id)
{
	new arrsize = ArraySize(retries_ids)
	for(new i; i < arrsize; i++)
	{
		if(id == ArrayGetCell(retries_ids, i))
		{
			ArrayDeleteItem(retries_ids, i)
			ArrayDeleteItem(retries_servers, i)
			return 1
		}
	}
	return 0
}

stock retry_add(id, server)
{
	ArrayPushCell(retries_ids, id)
	ArrayPushCell(retries_servers, server)
	return 1
}

stock sql_safe(dest[], len)
{
	replace_all(dest, len, "\\", "\\\\")
	replace_all(dest, len, "\0", "\\0")
	replace_all(dest, len, "\n", "\\n")
	replace_all(dest, len, "\r", "\\r")
	replace_all(dest, len, "\x1a", "\Z")
	replace_all(dest, len, "'", "\'")
	replace_all(dest, len, "^"", "\^"")
	
	return 1
}

stock is_user_retry(id)
{
	new arrsize = ArraySize(retries_ids)
	for(new i; i < arrsize; i++)
	{
		if(id == ArrayGetCell(retries_ids, i))
		{
			return 1
		}
	}
	return 0
}